<?php
session_start();
require 'config.php'; // Include your database configuration file

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("Location: login.php");
    exit();
}

$upi = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['upi'])) {
    $new_upi = htmlspecialchars(trim($_POST['upi']));
    $stmt = $conn->prepare("UPDATE upi_details SET upi = ? WHERE id = 1");
    if ($stmt) {
        $stmt->bind_param("s", $new_upi);
        $stmt->execute();
        $stmt->close();

        if (file_put_contents('../payment/upi.txt', $new_upi) !== false) {
            $upi = $new_upi;
            $status_message = 'UPI updated successfully!';
        } else {
            $status_message = 'Failed to write UPI to file.';
        }
    } else {
        $status_message = 'Database error: ' . $conn->error;
    }
} else {
    $stmt = $conn->prepare("SELECT upi FROM upi_details WHERE id = 1");
    if ($stmt) {
        $stmt->execute();
        $stmt->bind_result($upi);
        $stmt->fetch();
        $stmt->close();
    } else {
        $status_message = 'Failed to retrieve UPI.';
    }
}

$conn->close();

if (isset($_POST['logout'])) {
    session_destroy();
    header("Location: login.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Admin Panel</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap');

        body {
            font-family: 'Roboto', sans-serif;
            background: linear-gradient(135deg, #1e1e1e 0%, #2c3e50 100%);
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            overflow: hidden;
            color: #ccc;
            position: relative;
        }

        .background-ring {
            position: absolute;
            top: 50%;
            left: 50%;
            width: 400px;
            height: 400px;
            transform: translate(-50%, -50%);
            border-radius: 50%;
            border: 10px solid transparent;
            border-top: 10px solid #ff5722;
            border-right: 10px solid #ff9800;
            border-bottom: 10px solid #4caf50;
            border-left: 10px solid #2196f3;
            animation: spin 10s linear infinite;
            z-index: 0;
        }

        .background-ring-2 {
            position: absolute;
            top: 50%;
            left: 50%;
            width: 300px;
            height: 300px;
            transform: translate(-50%, -50%);
            border-radius: 50%;
            border: 10px solid transparent;
            border-top: 10px solid #4caf50;
            border-right: 10px solid #2196f3;
            border-bottom: 10px solid #ff5722;
            border-left: 10px solid #ff9800;
            animation: spin-reverse 15s linear infinite;
            z-index: 0;
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }
            100% {
                transform: rotate(360deg);
            }
        }

        @keyframes spin-reverse {
            0% {
                transform: rotate(0deg);
            }
            100% {
                transform: rotate(-360deg);
            }
        }

        .stars {
            position: absolute;
            width: 100%;
            height: 100%;
            background: transparent;
            z-index: 0;
            overflow: hidden;
        }

        .stars::before, .stars::after {
            content: '';
            position: absolute;
            top: -100px;
            left: -100px;
            width: 200%;
            height: 200%;
            background: transparent;
            box-shadow:
                0 0 2px #fff,
                20px 30px 2px #fff,
                40px 60px 2px #fff,
                60px 90px 2px #fff,
                80px 120px 2px #fff,
                100px 150px 2px #fff;
            animation: twinkling 10s infinite;
        }

        .stars::after {
            top: -200px;
            left: -200px;
            width: 300%;
            height: 300%;
            box-shadow:
                0 0 2px #fff,
                30px 40px 2px #fff,
                60px 80px 2px #fff,
                90px 120px 2px #fff,
                120px 160px 2px #fff,
                150px 200px 2px #fff;
            animation: twinkling 15s infinite;
        }

        @keyframes twinkling {
            0%, 100% {
                transform: translateY(0);
            }
            50% {
                transform: translateY(-200px);
            }
        }

        .container {
            background: rgba(0, 0, 0, 0.4);
            padding: 2rem;
            border-radius: 15px;
            box-shadow: 0 4px 30px rgba(0, 0, 0, 0.1);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            animation: fadeIn 2s ease-in-out;
            text-align: center;
            max-width: 400px;
            width: 90%;
            box-sizing: border-box;
            position: relative;
            z-index: 1;
        }

        .main-title {
            margin-bottom: 1rem;
            font-size: 2.5rem;
            text-transform: uppercase;
            animation: slideIn 1s ease-in-out;
            color: #fff;
        }

        form {
            display: flex;
            flex-direction: column;
            gap: 1rem;
        }

        label {
            margin-bottom: 0.5rem;
            font-weight: bold;
            text-align: left;
            color: #bbb;
        }

        input {
            padding: 0.7rem;
            border: none;
            border-radius: 5px;
            outline: none;
            background: rgba(255, 255, 255, 0.1);
            color: #fff;
            font-size: 1rem;
            transition: background 0.3s ease, border-color 0.3s ease;
        }

        input:focus {
            background: rgba(255, 255, 255, 0.2);
            border-color: #ff5722;
        }

        button {
            padding: 0.7rem;
            border: none;
            border-radius: 5px;
            background: #ff5722;
            color: white;
            font-size: 1rem;
            cursor: pointer;
            transition: background-color 0.3s ease, transform 0.3s ease;
            text-transform: uppercase;
        }

        button:hover {
            background-color: #e64a19;
            transform: scale(1.05);
        }

        #statusMessage {
            margin-top: 1rem;
            color: #ff5722;
            animation: fadeIn 1s ease-in-out;
        }

        .telegram-button {
            padding: 0.7rem 1.5rem;
            background-color: #0088cc;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            transition: background-color 0.3s ease, transform 0.3s ease;
            display: inline-block;
            margin-top: 1rem;
        }

        .telegram-button:hover {
            background-color: #006699;
            transform: scale(1.05);
        }

        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        @keyframes slideIn {
            from { transform: translateY(-50px); }
            to { transform: translateY(0); }
        }

        @media (max-width: 600px) {
            .background-ring {
                width: 300px;
                height: 300px;
                margin-top: -150px;
                margin-left: -150px;
            }

            .background-ring-2 {
                width: 200px;
                height: 200px;
                margin-top: -100px;
                margin-left: -100px;
            }

            .container {
                padding: 1.5rem;
            }

            .main-title {
                font-size: 2rem;
            }

            input, button {
                font-size: 0.9rem;
            }
        }
    </style>
</head>
<body>
    <div class="stars"></div>
    <div class="background-ring"></div>
    <div class="background-ring-2"></div>
    <div class="container">
        <h1 class="main-title">Code Mint</h1>
        <h1 class="main-title">Admin Panel</h1>
        <form method="POST" action="index.php">
            <label for="upi">ADD YOUR UPI:</label>
            <input type="text" id="upi" name="upi" value="<?php echo htmlspecialchars($upi); ?>" required>
            <button type="submit">Update UPI</button>
        </form>
        <?php if (isset($status_message)): ?>
        <p id="statusMessage"><?php echo $status_message; ?></p>
        <?php endif; ?>
        <a href="https://t.me/codemint" target="_blank" class="telegram-button">Telegram Support</a>
    </div>
</body>
</html>