<?php
// Generate a random order ID
$order_id = "ORD" . rand(100000, 999999);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order Placed Successfully</title>
    <!-- Font Awesome for Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        /* General Reset */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: Arial, sans-serif;
            background-color: #f7f7f7;
            display: flex;
            flex-direction: column;
            align-items: center;
            min-height: 100vh;
            overflow: hidden;
        }

        /* Simplified Header */
        .header {
            width: 100%;
            background-color: #2874f0;
            padding: 10px 20px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1000;
        }

        .header .logo {
            font-size: 24px;
            font-weight: bold;
            color: #fff;
            text-decoration: none;
        }

        .header .cart {
            position: relative;
            color: #fff;
            font-size: 20px;
            cursor: pointer;
        }

        .header .cart .badge {
            position: absolute;
            top: -10px;
            right: -10px;
            background-color: #ff6161;
            color: #fff;
            font-size: 12px;
            padding: 2px 6px;
            border-radius: 50%;
        }

        /* Full-Screen Centered Content */
        .container {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            text-align: center;
            background: #fff;
            width: 100%;
            height: 100vh;
            padding: 20px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
            margin-top: 60px; /* Space for the fixed header */
        }

        /* Animated Tick */
        .tick {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            background-color: #4CAF50;
            margin: 0 auto 20px;
            position: relative;
            display: flex;
            align-items: center; /* Center the icon vertically */
            justify-content: center; /* Center the icon horizontally */
            animation: tickAnimation 0.6s ease, pulse 2s infinite 1s;
        }

        .tick::before {
            content: '\f00c'; /* FontAwesome check icon */
            font-family: 'Font Awesome 5 Free';
            font-weight: 900;
            font-size: 50px;
            color: #fff;
        }

        /* Success Message */
        h1 {
            color: #4CAF50;
            font-size: 28px;
            margin-bottom: 10px;
            animation: fadeIn 1s ease forwards;
            opacity: 0;
        }

        p {
            font-size: 18px;
            color: #555;
            margin-bottom: 30px;
            animation: fadeIn 1s ease 0.5s forwards;
            opacity: 0;
        }

        /* Progress Bar */
        .progress-bar {
            display: flex;
            justify-content: space-between;
            position: relative;
            width: 80%;
            max-width: 400px;
            margin-bottom: 20px;
        }

        .progress-bar::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 0;
            right: 0;
            height: 4px;
            background-color: #e0e0e0;
            transform: translateY(-50%);
            z-index: 1;
        }

        .progress-bar::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 0;
            width: 50%; /* Highlight halfway to Shipped */
            height: 4px;
            background-color: #4CAF50;
            transform: translateY(-50%);
            z-index: 2;
            animation: progress 1.5s ease 1s forwards;
        }

        .progress-step {
            display: flex;
            flex-direction: column;
            align-items: center;
            z-index: 3;
        }

        .progress-step .icon {
            font-size: 24px;
            color: #333; /* Dark color for icons */
            margin-bottom: 10px;
            animation: fadeIn 1s ease forwards;
            opacity: 0;
        }

        .progress-step .dot {
            width: 10px;
            height: 10px;
            border-radius: 50%;
            background-color: #e0e0e0;
            margin-bottom: 10px;
        }

        .progress-step.active .dot {
            background-color: #4CAF50;
            animation: pulse 2s infinite 1.5s;
        }

        .progress-step.active .label {
            color: #4CAF50;
            font-weight: bold;
        }

        .progress-step .label {
            font-size: 14px;
            color: #555;
            animation: fadeIn 1s ease forwards;
            opacity: 0;
        }

        /* Shop More Button */
        .shop-more {
            display: inline-block;
            padding: 10px 20px;
            font-size: 16px;
            color: #fff;
            background-color: #2874f0;
            text-decoration: none;
            border-radius: 5px;
            transition: background-color 0.3s;
            animation: fadeIn 1s ease 1s forwards;
            opacity: 0;
        }

        .shop-more:hover {
            background-color: #1a5bb8;
        }

        /* Footer */
        .footer {
            text-align: center;
            font-size: 14px;
            color: #888;
            padding: 20px;
            position: fixed;
            bottom: 0;
            width: 100%;
            background: #f7f7f7;
            box-shadow: 0 -2px 4px rgba(0, 0, 0, 0.1);
        }

        .footer a {
            color: #2874f0;
            text-decoration: none;
        }

        .footer a:hover {
            text-decoration: underline;
        }

        /* Keyframes */
        @keyframes tickAnimation {
            0% {
                transform: scale(0);
            }
            50% {
                transform: scale(1.2);
            }
            100% {
                transform: scale(1);
            }
        }

        @keyframes pulse {
            0% {
                box-shadow: 0 0 0 0 rgba(76, 175, 80, 0.4);
            }
            70% {
                box-shadow: 0 0 0 10px rgba(76, 175, 80, 0);
            }
            100% {
                box-shadow: 0 0 0 0 rgba(76, 175, 80, 0);
            }
        }

        @keyframes fadeIn {
            0% {
                opacity: 0;
                transform: translateY(20px);
            }
            100% {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes progress {
            0% {
                width: 0;
            }
            100% {
                width: 50%;
            }
        }
    </style>
</head>
<body>
    <!-- Simplified Header -->
    <div class="header">
        <a href="../index.html" class="logo">Flipkart</a>
        <div class="cart">
            <i class="fas fa-shopping-cart"></i>
            <span class="badge">1</span>
        </div>
    </div>

    <!-- Full-Screen Centered Content -->
    <div class="container">
        <!-- Animated Green Tick -->
        <div class="tick"></div>

        <!-- Success Message -->
        <h1>Order Placed Successfully!</h1>
        <p>Your Order ID: <strong><?php echo $order_id; ?></strong></p>

        <!-- Progress Bar with Icons and Dots -->
        <div class="progress-bar">
            <div class="progress-step active">
                <div class="icon"><i class="fas fa-box"></i></div>
                <div class="dot"></div>
                <div class="label">Order Placed</div>
            </div>
            <div class="progress-step">
                <div class="icon"><i class="fas fa-truck"></i></div>
                <div class="dot"></div>
                <div class="label">Shipped</div>
            </div>
            <div class="progress-step">
                <div class="icon"><i class="fas fa-check-circle"></i></div>
                <div class="dot"></div>
                <div class="label">Delivered</div>
            </div>
        </div>

        <!-- Shop More Button -->
        <a href="../index.html" class="shop-more">Shop More</a>
    </div>

    <!-- Footer -->
    <div class="footer">
        <p><a href="privacy_policy.html">Privacy Policy</a> | <a href="terms_conditions.html">Terms & Conditions</a></p>
        <p>&copy; 2025 Flipkart. All rights reserved.</p>
    </div>
</body>
</html>