<?php
session_start();
require 'config.php'; // Include your database configuration file

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (isset($_POST['login'])) {
    $username = htmlspecialchars(trim($_POST['username']));
    $password = htmlspecialchars(trim($_POST['password']));

    // Prepare the SQL statement
    $stmt = $conn->prepare("SELECT id, password FROM users WHERE username = ?");
    if ($stmt) {
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $stmt->store_result();

        // Check if the user exists
        if ($stmt->num_rows === 1) {
            $stmt->bind_result($id, $hashed_password);
            $stmt->fetch();

            // Verify the password
            if (password_verify($password, $hashed_password)) {
                $_SESSION['loggedin'] = true;
                $_SESSION['userid'] = $id;
                session_regenerate_id(true); // Prevent session fixation
                header("Location: index.php");
                exit();
            } else {
                $error_message = 'Invalid Username or Password';
            }
        } else {
            $error_message = 'Invalid Username or Password';
        }
        $stmt->close();
    } else {
        $error_message = 'Database error: ' . $conn->error;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Login</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap');

        body {
            font-family: 'Roboto', sans-serif;
            background: linear-gradient(135deg, #1e1e1e 0%, #2c3e50 100%);
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            overflow: hidden;
            color: #ccc;
            position: relative;
        }

        .background-ring {
            position: absolute;
            top: 50%;
            left: 48%;
            width: 400px;
            height: 400px;
            transform: translate(-50%, -50%);
            border-radius: 50%;
            border: 10px solid transparent;
            border-top: 10px solid #ff5722;
            border-right: 10px solid #ff9800;
            border-bottom: 10px solid #4caf50;
            border-left: 10px solid #2196f3;
            animation: spin 10s linear infinite;
            z-index: 0;
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }
            100% {
                transform: rotate(360deg);
            }
        }

        .container {
            background: rgba(0, 0, 0, 0.4);
            padding: 2rem;
            border-radius: 15px;
            box-shadow: 0 4px 30px rgba(0, 0, 0, 0.1);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            animation: fadeIn 2s ease-in-out;
            text-align: center;
            max-width: 400px;
            width: 90%;
            box-sizing: border-box;
            position: relative;
            z-index: 1;
        }

        .main-title {
            margin-bottom: 1rem;
            font-size: 2.5rem;
            text-transform: uppercase;
            animation: slideIn 1s ease-in-out;
            color: #fff;
        }

        form {
            display: flex;
            flex-direction: column;
            gap: 1rem;
        }

        label {
            margin-bottom: 0.5rem;
            font-weight: bold;
            text-align: left;
            color: #bbb;
        }

        input {
            padding: 0.7rem;
            border: none;
            border-radius: 5px;
            outline: none;
            background: rgba(255, 255, 255, 0.1);
            color: #fff;
            font-size: 1rem;
            transition: background 0.3s ease, border-color 0.3s ease;
        }

        input:focus {
            background: rgba(255, 255, 255, 0.2);
            border-color: #ff5722;
        }

        button {
            padding: 0.7rem;
            border: none;
            border-radius: 5px;
            background: #ff5722;
            color: white;
            font-size: 1rem;
            cursor: pointer;
            transition: background-color 0.3s ease, transform 0.3s ease;
            text-transform: uppercase;
        }

        button:hover {
            background-color: #e64a19;
            transform: scale(1.05);
        }

        #statusMessage {
            margin-top: 1rem;
            color: #ff5722;
            animation: fadeIn 1s ease-in-out;
        }

        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        @keyframes slideIn {
            from { transform: translateY(-50px); }
            to { transform: translateY(0); }
        }

        @media (max-width: 600px) {
            .background-ring {
                width: 300px;
                height: 300px;
                margin-top: -150px;
                margin-left: -150px;
            }

            .container {
                padding: 1.5rem;
            }

            .main-title {
                font-size: 2rem;
            }

            input, button {
                font-size: 0.9rem;
            }
        }

        .floating-image {
            position: fixed;
            bottom: -15px;
            right: 20px;
            width: 100px;
            height: 100px;
            cursor: pointer;
            z-index: 2;
        }
    </style>
</head>
<body>
    <div class="background-ring"></div>
    <div class="container">
        <h1 class="main-title">Login</h1>
        <form method="POST" action="login.php" id="loginForm">
            <label for="username">Username:</label>
            <input type="text" id="username" name="username" required>
            <label for="password">Password:</label>
            <input type="password" id="password" name="password" required>
            <button type="submit" name="login">Login</button>
        </form>
        <?php if (isset($error_message)): ?>
        <p id="statusMessage"><?php echo $error_message; ?></p>
        <?php endif; ?>
    </div>
    <a href="https://telegram.me/cleanrose/">
        <img src="bot.png" alt="Floating Image" class="floating-image">
    </a>
    <script>
        document.getElementById('loginForm').addEventListener('submit', function(event) {
            const username = document.getElementById('username').value.trim();
            const password = document.getElementById('password').value.trim();
            if (username === '' || password === '') {
                event.preventDefault();
                alert('Please fill in both fields.');
            }
        });
    </script>
</body>
</html>