// Function to update UPI IDs dynamically on all buttons
async function updateUPI() {
    try {
        // Fetch the UPI ID from the upi.txt file
        const response = await fetch('upi.txt');
        console.log(response)
        const upiID = await response.text();

        // Select all buttons with the class 'buynow-button'
        document.querySelectorAll('.buynow-button').forEach(button => {
            // Update the 'onclick' attribute with the UPI ID from the file
            button.setAttribute('onclick', `payNow('${upiID.trim()}')`);
        });
    } catch (error) {
        console.error('Error fetching UPI ID:', error);
    }
}

// Run the updateUPI function when the page loads
window.onload = updateUPI;
